/*******************************************************
Filename		:  di_biopart.sql
Release 		:  c2.0
SIR			:  1509
Description		:  Creates the dimension table DI_BIOPART and related objects.
Author			:  Thieu Nguyen
Date			:  7/14/2003
Comments		:  
**********************************************************/

connect storetw/storetw@storet.sdc
spool di_biopart.log

drop sequence seq_biopart;

create sequence seq_biopart
start with 1 increment by 1 nomaxvalue nocycle cache 10;

drop table di_biopart;
create table di_biopart
(PK_ISN number(12) not null,
 BIOPART_NAME varchar2(30) not null)
tablespace storetdata
storage (initial 256K next 256K)
nologging;

alter table di_biopart
add constraint pk_biopart primary key (pk_isn)
using index
tablespace storetindx
storage (initial 128K next 128K);

--add data to di_biopart
set serveroutput on
declare
--cursor c1 is SELECT NAME FROM storet.TSRBIOPT;
cursor c1 is select distinct biopart_name from fa_biological_result
where biopart_name is not null;
begin
for c1_var in c1 loop
insert into di_biopart(PK_ISN,BIOPART_NAME)
values(seq_biopart.nextval,c1_var.BIOPART_NAME);
end loop;
commit;
end;
/

--update fks in FA_BIOLOGICAL_RESULT
declare
cursor c1 is select * from di_biopart;

begin
for c1_var in c1 loop
update FA_BIOLOGICAL_RESULT
set FK_BIOPART = c1_var.pk_isn
where BIOPART_NAME = c1_var.BIOPART_NAME;
commit;
end loop;
commit;
end;
/
spool off;
